/* ============ */
/* clsndefs.h	*/
/* ============ */
/* ==================================================================== */
/*         TYPEDEFS, #DEFINES AND PROTOTYPES FOR COLLISION TEST 	*/
/* ==================================================================== */
# if defined(__CLSNDEFS_H__)
#	/* Do Nothing */
# else
#	define	__CLSNDEFS_H__

# if !defined(__DEFCODES)

typedef	unsigned char		UCHAR;
typedef	unsigned int		UINT;
typedef	unsigned long		ULONG;

# if !defined(DEBUG)
#	define	P( F )
# else
#	define	P( F )	F
# endif

#define	SQR(x)	((x) * (x))

#define	FALSE	0
#define	TRUE	1
# endif

#define	TMAX	8		/* No. Collision Probs. in Table */

#define	MAX_NUM_BALLS		16384
#define	MIN_NUM_BALLS		64
#define	MAX_NUM_DATA_BITS	20
#define	MAX_NUM_URNS		1048576L
#define	MIN_NUM_URNS		4096
#define	MAX_NUM_USER_BITS	10
#define	MIN_NUM_USER_BITS	1

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */
typedef	struct	ClsnDataStru
    {
	long	NumCategories;		/* (m) - Number of Urns		*/
	UINT	NumObs;			/* (n) - Number of Balls	*/
	ULONG	NumVariates;		/* No. Variates Required	*/
	int	BitMask;		/* Bit Mask for GetBitVector()	*/
	int	NumBits;		/* Number of Bits in BitMask	*/
	int	NumParts;		/* No. Bit Packets in Vector	*/
	double	ClsnProbs[TMAX];	/* Collision Probabilities	*/
	int	ClsnStats[TMAX];	/* Collision Statistics		*/
	double	PctPts[TMAX];		/* Auxiliary Percentage Table	*/
	int	NumHits;		/* Number of Collisions Scored	*/
	double	HitProb;		/* Corresponding Probability	*/
	int	CallStatusOK;		/* 0 = FALSE, 1 = TRUE		*/
	int	(*RandFun) F((void));	/* Addr. of Generating Function	*/
    }
	CLSN_DATA_STRU;

extern	void	CalcCollisionProbs F((struct ClsnDataStru *));
extern	void	GetCollisionData F((struct ClsnDataStru *));
extern	void	SetCollisionControls F((struct ClsnDataStru *));

# undef F
/* INDENT ON */

# endif				/* <<< __CLSNDEFS_H__ >>> */
